// =============================================================================
// -----------------------------------------------------------------------------
// Program
// -----------------------------------------------------------------------------

#include <stdio.h>
#include <windows.h>
#include <direct.h>
#include "bitmap.h"

// =============================================================================
// -----------------------------------------------------------------------------
// Main routine
// -----------------------------------------------------------------------------

int main (int ArgNumber, char **ArgList, char **EnvList)

{
	printf ("Scale BMP - by MarkeyJester\n\n");
	if (ArgNumber <= 1)
	{
		printf (" -> Drag and drop bitmap files onto this program to scale\n\n");
		printf ("    Some of the frames are too large when they're ripped\n"
			"    so this tool will scale them down so more fits into the\n"
			"    ripped film...\n");
		printf ("\nPress enter key to exit...\n");
		fflush (stdin); getchar ( ); return (0x00);
	}
	int Scale = 0;
	printf (" -> Please type scale amount in percentage: ");
	scanf ("%d", &Scale);
	printf ("\n");

	char Direct [0x1000];
	char FileName [0x100];
	IMG Image;
	for (int ArgCount = 1; ArgCount < ArgNumber; ArgCount++)
	{
		int Folder;
		for (int Loc = 0; ; Loc++)
		{
			Direct [Loc] = ArgList [ArgCount] [Loc];
			if (Direct [Loc] == '\\' || Direct [Loc] == '/')
			{
				Folder = Loc + 1;
			}
			if (Direct [Loc] == 0) { break; }
		}
		strcpy (FileName, &Direct [Folder]);
		printf (" -> \"%s\"\n", FileName);
		snprintf (&Direct [Folder], 0x1000-Folder, "BACKUP\\%s", FileName);
		if (ImageLoad (&Image, Direct) != 0)
		{
			strcpy (&Direct [Folder], FileName);
			int Return = ImageLoad (&Image, Direct);
			if (Return != 0)
			{
				switch (Return)
				{
					case 1: printf ("    Error; bitmap file cannot be opened\n"); break;
					case 2: printf ("    Error; bitmap allocation error\n"); break;
					case 3: printf ("    Error; bitmap fread didn't copy full size\n"); break;
					case 4: printf ("    Error; bitmap pixel format not supported\n"); break;
					case 5: printf ("    Error; bitmap image is not a valid \"BM\" format\n"); break;
					case 6: printf ("    Error; bitmap compression not supported\n"); break;
				}
				printf ("\nPress enter key to exit...\n");
				fflush (stdin); getchar ( );
				return (0x00);
			}
		}
		else
		{
			printf ("    Using backup...\n");
		}
		snprintf (&Direct [Folder], 0x1000-Folder, "BACKUP\\");
		mkdir (Direct);
		snprintf (&Direct [Folder], 0x1000-Folder, "BACKUP\\%s", FileName);
		SaveBMP (&Image, Direct, 24);

		PIX_BGRA PadColour = Image.Data [0];
		int OldX = Image.SizeX;
		int OldY = Image.SizeY;
		int NewX = (Image.SizeX * Scale) / 100;
		int NewY = (Image.SizeY * Scale) / 100;
		PerformResize (&Image, NewX, NewY, FALSE);
		TruncateImage (&Image, (NewX-OldX)/2, (NewY-OldY)/2, OldX+((NewX-OldX)/2), OldY+((NewY-OldY)/2), PadColour);
		strcpy (&Direct [Folder], FileName);
		SaveBMP (&Image, Direct, 24);
	}
	printf ("\nPress enter key to exit...\n");
	fflush (stdin); getchar ( ); return (0x00);
}

// =============================================================================
